'use client'

import { useState } from 'react'
import { useRouter } from 'next/navigation'
import Link from 'next/link'
import { Button } from '@/components/ui/button'
import { Input } from '@/components/ui/input'
import { Label } from '@/components/ui/label'
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card'
import { Alert, AlertDescription } from '@/components/ui/alert'
import { Badge } from '@/components/ui/badge'
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs'
import { Eye, EyeOff, Shield, Users, Settings, FileText, BarChart3 } from 'lucide-react'

export default function AdminLoginPage() {
  const [showPassword, setShowPassword] = useState(false)
  const [isLoading, setIsLoading] = useState(false)
  const [error, setError] = useState('')
  const [selectedRole, setSelectedRole] = useState('super_admin')
  const router = useRouter()

  const adminRoles = [
    {
      id: 'super_admin',
      name: 'Super Admin',
      description: 'Akses penuh ke semua fitur',
      icon: Shield,
      color: 'bg-red-500',
      credentials: { username: 'superadmin', password: 'admin123' }
    },
    {
      id: 'admin',
      name: 'Admin',
      description: 'Kelola konten dan laporan',
      icon: Settings,
      color: 'bg-blue-500',
      credentials: { username: 'admin', password: 'admin123' }
    },
    {
      id: 'content_manager',
      name: 'Content Manager',
      description: 'Kelola berita dan galeri',
      icon: FileText,
      color: 'bg-green-500',
      credentials: { username: 'content', password: 'admin123' }
    },
    {
      id: 'data_analyst',
      name: 'Data Analyst',
      description: 'Analisis data dan laporan',
      icon: BarChart3,
      color: 'bg-purple-500',
      credentials: { username: 'analyst', password: 'admin123' }
    },
    {
      id: 'customer_service',
      name: 'Customer Service',
      description: 'Respond laporan dan chat',
      icon: Users,
      color: 'bg-orange-500',
      credentials: { username: 'cs', password: 'admin123' }
    }
  ]

  const handleLogin = async (e: React.FormEvent<HTMLFormElement>) => {
    e.preventDefault()
    setIsLoading(true)
    setError('')

    const formData = new FormData(e.currentTarget)
    const username = formData.get('username') as string
    const password = formData.get('password') as string

    // Simulasi autentikasi (dalam production, gunakan API yang aman)
    setTimeout(() => {
      const role = adminRoles.find(r => r.id === selectedRole)
      if (role && username === role.credentials.username && password === role.credentials.password) {
        // Simpan session (dalam production, gunakan JWT yang aman)
        document.cookie = `auth-token=${btoa(JSON.stringify({
          role: role.id,
          name: role.name,
          loginTime: new Date().toISOString()
        }))}; path=/; max-age=3600` // 1 hour expiry
        localStorage.setItem('admin_session', JSON.stringify({
          role: role.id,
          name: role.name,
          loginTime: new Date().toISOString()
        }))
        router.push('/admin/dashboard')
      } else {
        setError('Username atau password salah')
      }
      setIsLoading(false)
    }, 1000)
  }

  const selectedRoleData = adminRoles.find(r => r.id === selectedRole)

  return (
    <div className="min-h-screen bg-gradient-to-br from-slate-50 to-slate-100 flex items-center justify-center p-4">
      <div className="w-full max-w-6xl">
        {/* Header */}
        <div className="text-center mb-8">
          <div className="flex items-center justify-center mb-4">
            <div className="h-12 w-12 rounded-full bg-primary flex items-center justify-center">
              <Shield className="h-6 w-6 text-primary-foreground" />
            </div>
          </div>
          <h1 className="text-3xl font-bold text-slate-900 mb-2">
            Admin Portal
          </h1>
          <p className="text-slate-600">
            Sistem Manajemen Konten Politisi Indonesia
          </p>
        </div>

        <div className="grid lg:grid-cols-2 gap-8">
          {/* Login Form */}
          <Card className="shadow-xl">
            <CardHeader>
              <CardTitle>Login Admin</CardTitle>
              <CardDescription>
                Pilih role dan masukkan kredensial Anda
              </CardDescription>
            </CardHeader>
            <CardContent>
              <Tabs value={selectedRole} onValueChange={setSelectedRole} className="mb-6">
                <TabsList className="grid w-full grid-cols-5">
                  {adminRoles.map((role) => (
                    <TabsTrigger key={role.id} value={role.id} className="text-xs">
                      {role.name.split(' ')[0]}
                    </TabsTrigger>
                  ))}
                </TabsList>
              </Tabs>

              {selectedRoleData && (
                <div className="mb-6 p-4 rounded-lg bg-slate-50 border">
                  <div className="flex items-center space-x-3 mb-2">
                    <div className={`p-2 rounded-full ${selectedRoleData.color}`}>
                      <selectedRoleData.icon className="h-4 w-4 text-white" />
                    </div>
                    <div>
                      <h3 className="font-semibold">{selectedRoleData.name}</h3>
                      <p className="text-sm text-slate-600">{selectedRoleData.description}</p>
                    </div>
                  </div>
                  <div className="mt-3 p-2 bg-white rounded border text-xs">
                    <p className="font-mono">
                      Demo: {selectedRoleData.credentials.username} / {selectedRoleData.credentials.password}
                    </p>
                  </div>
                </div>
              )}

              <form onSubmit={handleLogin} className="space-y-4">
                <div className="space-y-2">
                  <Label htmlFor="username">Username</Label>
                  <Input
                    id="username"
                    name="username"
                    type="text"
                    placeholder="Masukkan username"
                    required
                    disabled={isLoading}
                  />
                </div>

                <div className="space-y-2">
                  <Label htmlFor="password">Password</Label>
                  <div className="relative">
                    <Input
                      id="password"
                      name="password"
                      type={showPassword ? 'text' : 'password'}
                      placeholder="Masukkan password"
                      required
                      disabled={isLoading}
                    />
                    <Button
                      type="button"
                      variant="ghost"
                      size="sm"
                      className="absolute right-0 top-0 h-full px-3 py-2 hover:bg-transparent"
                      onClick={() => setShowPassword(!showPassword)}
                    >
                      {showPassword ? (
                        <EyeOff className="h-4 w-4" />
                      ) : (
                        <Eye className="h-4 w-4" />
                      )}
                    </Button>
                  </div>
                </div>

                {error && (
                  <Alert variant="destructive">
                    <AlertDescription>{error}</AlertDescription>
                  </Alert>
                )}

                <Button type="submit" className="w-full" disabled={isLoading}>
                  {isLoading ? 'Sedang login...' : 'Login'}
                </Button>
              </form>

              <div className="mt-6 text-center">
                <Link href="/" className="text-sm text-slate-600 hover:text-primary">
                  ← Kembali ke Website Utama
                </Link>
              </div>
            </CardContent>
          </Card>

          {/* Role Information */}
          <div className="space-y-4">
            <Card>
              <CardHeader>
                <CardTitle className="flex items-center">
                  <Shield className="mr-2 h-5 w-5" />
                  Hak Akses Role
                </CardTitle>
              </CardHeader>
              <CardContent className="space-y-4">
                {adminRoles.map((role) => (
                  <div key={role.id} className="flex items-start space-x-3">
                    <div className={`p-1 rounded-full ${role.color} mt-1`}>
                      <role.icon className="h-3 w-3 text-white" />
                    </div>
                    <div className="flex-1">
                      <h4 className="font-medium text-sm">{role.name}</h4>
                      <p className="text-xs text-slate-600">{role.description}</p>
                    </div>
                    {selectedRole === role.id && (
                      <Badge variant="secondary" className="text-xs">
                        Dipilih
                      </Badge>
                    )}
                  </div>
                ))}
              </CardContent>
            </Card>

            <Card>
              <CardHeader>
                <CardTitle>Informasi Keamanan</CardTitle>
              </CardHeader>
              <CardContent>
                <div className="space-y-2 text-sm text-slate-600">
                  <p>• Gunakan kredensial yang telah disediakan</p>
                  <p>• Jangan bagikan password kepada siapa pun</p>
                  <p>• Logout setelah selesai menggunakan sistem</p>
                  <p>• Sistem mencatat semua aktivitas login</p>
                </div>
              </CardContent>
            </Card>
          </div>
        </div>
      </div>
    </div>
  )
}