import type { Metadata } from "next";
import { Geist, Geist_Mono } from "next/font/google";
import "./globals.css";
import { Toaster } from "@/components/ui/toaster";
import { ThemeProvider } from "@/components/theme-provider";

const geistSans = Geist({
  variable: "--font-geist-sans",
  subsets: ["latin"],
});

const geistMono = Geist_Mono({
  variable: "--font-geist-mono",
  subsets: ["latin"],
});

export const metadata: Metadata = {
  title: "Politisi Indonesia - Melayani Rakyat",
  description: "Website resmi politisi Indonesia. Berjuang untuk kemakmuran dan keadilan sosial bagi seluruh rakyat Indonesia.",
  keywords: ["politisi", "Indonesia", "pelayanan", "rakyat", "visi misi", "program kerja"],
  authors: [{ name: "Tim Media Politisi Indonesia" }],
  icons: {
    icon: "/favicon.ico",
  },
  openGraph: {
    title: "Politisi Indonesia - Melayani Rakyat",
    description: "Berkomitmen untuk memberikan pelayanan terbaik dan memperjuangkan keadilan sosial",
    url: "/",
    siteName: "Politisi Indonesia",
    type: "website",
  },
  twitter: {
    card: "summary_large_image",
    title: "Politisi Indonesia - Melayani Rakyat",
    description: "Berkomitmen untuk memberikan pelayanan terbaik dan memperjuangkan keadilan sosial",
  },
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="id" suppressHydrationWarning>
      <body
        className={`${geistSans.variable} ${geistMono.variable} antialiased bg-background text-foreground`}
      >
        <ThemeProvider
          attribute="class"
          defaultTheme="system"
          enableSystem
          disableTransitionOnChange
        >
          {children}
          <Toaster />
        </ThemeProvider>
      </body>
    </html>
  );
}
