'use client'

import Header from '@/components/layout/Header'
import Footer from '@/components/layout/Footer'
import { Card, CardContent } from '@/components/ui/card'
import { Badge } from '@/components/ui/badge'
import { Button } from '@/components/ui/button'
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs'
import { 
  User, 
  Calendar, 
  MapPin, 
  Phone, 
  Mail, 
  Award, 
  BookOpen, 
  Briefcase,
  Heart,
  Target,
  Users,
  Download,
  Share2
} from 'lucide-react'

export default function ProfilPage() {
  const biodata = {
    nama: "Dr. Budi Santoso, S.H., M.H.",
    gelar: "Anggota DPR RI",
    tempatLahir: "Jakarta",
    tanggalLahir: "15 Maret 1975",
    agama: "Islam",
    status: "Menikah",
    alamat: "Jakarta Selatan, DKI Jakarta",
    email: "budi.santoso@dpr.go.id",
    telepon: "+62 812-3456-7890"
  }

  const pendidikan = [
    {
      jenjang: "S3 (Doktor)",
      jurusan: "Ilmu Hukum",
      universitas: "Universitas Indonesia",
      tahun: "2010-2014"
    },
    {
      jenjang: "S2 (Magister)",
      jurusan: "Ilmu Hukum",
      universitas: "Universitas Indonesia",
      tahun: "2005-2008"
    },
    {
      jenjang: "S1 (Sarjana)",
      jurusan: "Ilmu Hukum",
      universitas: "Universitas Indonesia",
      tahun: "1998-2002"
    }
  ]

  const pengalaman = [
    {
      jabatan: "Anggota DPR RI",
      lembaga: "Komisi X DPR RI",
      periode: "2019 - Sekarang"
    },
    {
      jabatan: "Ketua Fraksi",
      lembaga: "Fraksi Partai Indonesia",
      periode: "2018 - 2019"
    },
    {
      jabatan: "Anggota DPRD",
      lembaga: "DPRD Provinsi DKI Jakarta",
      periode: "2014 - 2018"
    }
  ]

  const prestasi = [
    {
      judul: "Politisi Terbaik 2023",
      pemberi: "Media Politik Indonesia",
      tahun: "2023"
    },
    {
      judul: "Penghargaan Kepedulian Sosial",
      pemberi: "Kementerian Sosial RI",
      tahun: "2022"
    },
    {
      judul: "Tokoh Perubahan",
      pemberi: "Lembaga Survei Nasional",
      tahun: "2021"
    }
  ]

  return (
    <div className="min-h-screen bg-background">
      <Header />
      
      {/* Hero Section */}
      <section className="bg-gradient-to-br from-primary/10 to-secondary/10 py-20">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <div className="text-center mb-8">
              <Badge variant="secondary" className="mb-4">
                Profil Lengkap
              </Badge>
              <h1 className="text-4xl md:text-5xl font-bold mb-4">
                {biodata.nama}
              </h1>
              <p className="text-xl text-muted-foreground mb-6">
                {biodata.gelar}
              </p>
              
              <div className="flex justify-center space-x-4">
                <Button size="lg" className="group">
                  <Heart className="mr-2 h-4 w-4" />
                  Dukung Kami
                </Button>
                <Button size="lg" variant="outline" className="group">
                  <Share2 className="mr-2 h-4 w-4" />
                  Bagikan Profil
                </Button>
              </div>
            </div>

            {/* Quick Info */}
            <div className="grid grid-cols-2 md:grid-cols-4 gap-4 mt-12">
              <Card className="text-center">
                <CardContent className="p-4">
                  <Users className="h-8 w-8 mx-auto mb-2 text-primary" />
                  <div className="text-2xl font-bold">10,000+</div>
                  <div className="text-sm text-muted-foreground">Relawan</div>
                </CardContent>
              </Card>
              <Card className="text-center">
                <CardContent className="p-4">
                  <Target className="h-8 w-8 mx-auto mb-2 text-primary" />
                  <div className="text-2xl font-bold">50+</div>
                  <div className="text-sm text-muted-foreground">Program</div>
                </CardContent>
              </Card>
              <Card className="text-center">
                <CardContent className="p-4">
                  <Award className="h-8 w-8 mx-auto mb-2 text-primary" />
                  <div className="text-2xl font-bold">25+</div>
                  <div className="text-sm text-muted-foreground">Penghargaan</div>
                </CardContent>
              </Card>
              <Card className="text-center">
                <CardContent className="p-4">
                  <Briefcase className="h-8 w-8 mx-auto mb-2 text-primary" />
                  <div className="text-2xl font-bold">20+</div>
                  <div className="text-sm text-muted-foreground">Tahun Pengalaman</div>
                </CardContent>
              </Card>
            </div>
          </div>
        </div>
      </section>

      {/* Detailed Information */}
      <section className="py-20">
        <div className="container mx-auto px-4">
          <div className="max-w-4xl mx-auto">
            <Tabs defaultValue="biodata" className="w-full">
              <TabsList className="grid w-full grid-cols-4">
                <TabsTrigger value="biodata">Biodata</TabsTrigger>
                <TabsTrigger value="pendidikan">Pendidikan</TabsTrigger>
                <TabsTrigger value="pengalaman">Pengalaman</TabsTrigger>
                <TabsTrigger value="prestasi">Prestasi</TabsTrigger>
              </TabsList>

              <TabsContent value="biodata" className="mt-8">
                <Card>
                  <CardContent className="p-8">
                    <div className="grid md:grid-cols-2 gap-8">
                      <div className="space-y-6">
                        <h3 className="text-xl font-semibold flex items-center">
                          <User className="mr-2 h-5 w-5 text-primary" />
                          Informasi Pribadi
                        </h3>
                        
                        <div className="space-y-4">
                          <div className="flex justify-between py-2 border-b">
                            <span className="text-muted-foreground">Nama Lengkap</span>
                            <span className="font-medium">{biodata.nama}</span>
                          </div>
                          <div className="flex justify-between py-2 border-b">
                            <span className="text-muted-foreground">Tempat Lahir</span>
                            <span className="font-medium">{biodata.tempatLahir}</span>
                          </div>
                          <div className="flex justify-between py-2 border-b">
                            <span className="text-muted-foreground">Tanggal Lahir</span>
                            <span className="font-medium">{biodata.tanggalLahir}</span>
                          </div>
                          <div className="flex justify-between py-2 border-b">
                            <span className="text-muted-foreground">Agama</span>
                            <span className="font-medium">{biodata.agama}</span>
                          </div>
                          <div className="flex justify-between py-2 border-b">
                            <span className="text-muted-foreground">Status</span>
                            <span className="font-medium">{biodata.status}</span>
                          </div>
                        </div>
                      </div>

                      <div className="space-y-6">
                        <h3 className="text-xl font-semibold flex items-center">
                          <MapPin className="mr-2 h-5 w-5 text-primary" />
                          Kontak & Alamat
                        </h3>
                        
                        <div className="space-y-4">
                          <div className="flex justify-between py-2 border-b">
                            <span className="text-muted-foreground">Alamat</span>
                            <span className="font-medium text-right">{biodata.alamat}</span>
                          </div>
                          <div className="flex justify-between py-2 border-b">
                            <span className="text-muted-foreground">Email</span>
                            <span className="font-medium">{biodata.email}</span>
                          </div>
                          <div className="flex justify-between py-2 border-b">
                            <span className="text-muted-foreground">Telepon</span>
                            <span className="font-medium">{biodata.telepon}</span>
                          </div>
                        </div>

                        <div className="pt-4">
                          <Button variant="outline" className="w-full">
                            <Download className="mr-2 h-4 w-4" />
                            Download CV
                          </Button>
                        </div>
                      </div>
                    </div>
                  </CardContent>
                </Card>
              </TabsContent>

              <TabsContent value="pendidikan" className="mt-8">
                <Card>
                  <CardContent className="p-8">
                    <h3 className="text-xl font-semibold mb-6 flex items-center">
                      <BookOpen className="mr-2 h-5 w-5 text-primary" />
                      Riwayat Pendidikan
                    </h3>
                    
                    <div className="space-y-6">
                      {pendidikan.map((item, index) => (
                        <div key={index} className="flex items-start space-x-4 p-4 rounded-lg border">
                          <div className="p-2 rounded-full bg-primary/10">
                            <BookOpen className="h-5 w-5 text-primary" />
                          </div>
                          <div className="flex-1">
                            <h4 className="font-semibold">{item.jenjang}</h4>
                            <p className="text-muted-foreground">{item.jurusan}</p>
                            <p className="text-sm text-muted-foreground">{item.universitas}</p>
                            <Badge variant="secondary" className="mt-2">
                              {item.tahun}
                            </Badge>
                          </div>
                        </div>
                      ))}
                    </div>
                  </CardContent>
                </Card>
              </TabsContent>

              <TabsContent value="pengalaman" className="mt-8">
                <Card>
                  <CardContent className="p-8">
                    <h3 className="text-xl font-semibold mb-6 flex items-center">
                      <Briefcase className="mr-2 h-5 w-5 text-primary" />
                      Pengalaman Kerja
                    </h3>
                    
                    <div className="space-y-6">
                      {pengalaman.map((item, index) => (
                        <div key={index} className="flex items-start space-x-4 p-4 rounded-lg border">
                          <div className="p-2 rounded-full bg-primary/10">
                            <Briefcase className="h-5 w-5 text-primary" />
                          </div>
                          <div className="flex-1">
                            <h4 className="font-semibold">{item.jabatan}</h4>
                            <p className="text-muted-foreground">{item.lembaga}</p>
                            <Badge variant="secondary" className="mt-2">
                              {item.periode}
                            </Badge>
                          </div>
                        </div>
                      ))}
                    </div>
                  </CardContent>
                </Card>
              </TabsContent>

              <TabsContent value="prestasi" className="mt-8">
                <Card>
                  <CardContent className="p-8">
                    <h3 className="text-xl font-semibold mb-6 flex items-center">
                      <Award className="mr-2 h-5 w-5 text-primary" />
                      Prestasi & Penghargaan
                    </h3>
                    
                    <div className="space-y-6">
                      {prestasi.map((item, index) => (
                        <div key={index} className="flex items-start space-x-4 p-4 rounded-lg border">
                          <div className="p-2 rounded-full bg-primary/10">
                            <Award className="h-5 w-5 text-primary" />
                          </div>
                          <div className="flex-1">
                            <h4 className="font-semibold">{item.judul}</h4>
                            <p className="text-muted-foreground">{item.pemberi}</p>
                            <Badge variant="secondary" className="mt-2">
                              {item.tahun}
                            </Badge>
                          </div>
                        </div>
                      ))}
                    </div>
                  </CardContent>
                </Card>
              </TabsContent>
            </Tabs>
          </div>
        </div>
      </section>
      
      <Footer />
    </div>
  )
}