import { Card, CardContent } from '@/components/ui/card'
import { Badge } from '@/components/ui/badge'
import { Button } from '@/components/ui/button'
import { Calendar, Clock, ArrowRight, User } from 'lucide-react'
import Link from 'next/link'

export default function BeritaTerbaru() {
  // Sample data - akan diganti dengan data dari database
  const berita = [
    {
      id: 1,
      title: "Program Bantuan UMKM Sukses Diluncurkan di Jakarta",
      excerpt: "Program bantuan modal usaha untuk pelaku UMKM telah resmi diluncurkan dan mendapat sambutan positif dari masyarakat.",
      category: "Ekonomi",
      author: "Tim Media",
      date: "2 jam yang lalu",
      readTime: "3 menit",
      thumbnail: "/api/placeholder/400/250",
      featured: true
    },
    {
      id: 2,
      title: "Kunjungan ke Pusat Kesehatan Masyarakat di Bekasi",
      excerpt: "Meninjau langsung kondisi fasilitas kesehatan dan berdialog dengan tenaga medis serta pasien.",
      category: "Kesehatan",
      author: "Tim Media",
      date: "5 jam yang lalu",
      readTime: "4 menit",
      thumbnail: "/api/placeholder/400/250",
      featured: false
    },
    {
      id: 3,
      title: "Sosialisasi Program Pendidikan Gratis di Tangerang",
      excerpt: "Mengenalkan program pendidikan gratis kepada masyarakat dan menjawab berbagai pertanyaan terkait implementasinya.",
      category: "Pendidikan",
      author: "Tim Media",
      date: "1 hari yang lalu",
      readTime: "5 menit",
      thumbnail: "/api/placeholder/400/250",
      featured: false
    }
  ]

  const categoryColors: Record<string, string> = {
    "Ekonomi": "bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-300",
    "Kesehatan": "bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-300",
    "Pendidikan": "bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-300",
    "Sosial": "bg-purple-100 text-purple-800 dark:bg-purple-900 dark:text-purple-300",
    "Infrastruktur": "bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-300"
  }

  return (
    <section className="py-20">
      <div className="container mx-auto px-4">
        <div className="flex justify-between items-center mb-12">
          <div>
            <h2 className="text-3xl md:text-4xl font-bold mb-4">
              Berita Terbaru
            </h2>
            <p className="text-lg text-muted-foreground">
              Update terkini kegiatan dan program kerja
            </p>
          </div>
          <Link href="/berita">
            <Button variant="outline" className="group">
              Lihat Semua
              <ArrowRight className="ml-2 h-4 w-4 transition-transform group-hover:translate-x-1" />
            </Button>
          </Link>
        </div>

        <div className="grid lg:grid-cols-3 md:grid-cols-2 gap-8">
          {berita.map((article) => (
            <Card key={article.id} className="group hover:shadow-lg transition-all duration-300 overflow-hidden">
              {/* Thumbnail */}
              <div className="relative aspect-video overflow-hidden">
                <div className="w-full h-full bg-gradient-to-br from-primary/20 to-secondary/20 flex items-center justify-center">
                  <div className="text-center text-muted-foreground">
                    <div className="w-16 h-16 mx-auto mb-2 rounded-full bg-muted flex items-center justify-center">
                      📰
                    </div>
                    <p className="text-sm">Gambar Berita</p>
                  </div>
                </div>
                
                {/* Featured Badge */}
                {article.featured && (
                  <Badge className="absolute top-4 left-4 bg-primary text-primary-foreground">
                    Utama
                  </Badge>
                )}

                {/* Category Badge */}
                <Badge 
                  variant="secondary" 
                  className={`absolute top-4 right-4 ${categoryColors[article.category] || 'bg-gray-100 text-gray-800'}`}
                >
                  {article.category}
                </Badge>
              </div>

              <CardContent className="p-6">
                <div className="space-y-4">
                  {/* Meta Info */}
                  <div className="flex items-center justify-between text-sm text-muted-foreground">
                    <div className="flex items-center space-x-4">
                      <div className="flex items-center space-x-1">
                        <User className="h-3 w-3" />
                        <span>{article.author}</span>
                      </div>
                      <div className="flex items-center space-x-1">
                        <Clock className="h-3 w-3" />
                        <span>{article.readTime}</span>
                      </div>
                    </div>
                    <div className="flex items-center space-x-1">
                      <Calendar className="h-3 w-3" />
                      <span>{article.date}</span>
                    </div>
                  </div>

                  {/* Content */}
                  <div className="space-y-2">
                    <h3 className="text-xl font-semibold line-clamp-2 group-hover:text-primary transition-colors">
                      {article.title}
                    </h3>
                    <p className="text-muted-foreground line-clamp-3">
                      {article.excerpt}
                    </p>
                  </div>

                  {/* Read More */}
                  <Link 
                    href={`/berita/${article.id}`}
                    className="inline-flex items-center text-primary hover:underline text-sm font-medium"
                  >
                    Baca Selengkapnya
                    <ArrowRight className="ml-1 h-3 w-3" />
                  </Link>
                </div>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* Newsletter Subscription */}
        <div className="mt-16 text-center bg-muted/50 rounded-2xl p-8">
          <h3 className="text-2xl font-bold mb-4">
            Tetap Update dengan Berita Terbaru
          </h3>
          <p className="text-muted-foreground mb-6 max-w-2xl mx-auto">
            Dapatkan informasi terkini mengenai kegiatan dan program kerja langsung di inbox Anda
          </p>
          <div className="flex flex-col sm:flex-row gap-4 max-w-md mx-auto">
            <input
              type="email"
              placeholder="Masukkan email Anda"
              className="flex-1 px-4 py-3 rounded-lg border border-border bg-background focus:outline-none focus:ring-2 focus:ring-primary"
            />
            <Button className="px-6">
              Berlangganan
            </Button>
          </div>
        </div>
      </div>
    </section>
  )
}