'use client'

import { useState } from 'react'
import { Button } from '@/components/ui/button'
import { Badge } from '@/components/ui/badge'
import { Play, ArrowRight, Heart, Users, Award } from 'lucide-react'
import Image from 'next/image'

export default function Hero() {
  const [isPlaying, setIsPlaying] = useState(false)

  const stats = [
    { icon: Users, label: 'Relawan', value: '10,000+' },
    { icon: Heart, label: 'Dukungan', value: '50,000+' },
    { icon: Award, label: 'Penghargaan', value: '25+' },
  ]

  return (
    <section className="relative min-h-screen flex items-center justify-center bg-gradient-to-br from-primary/10 via-background to-secondary/10">
      {/* Background Pattern */}
      <div className="absolute inset-0 bg-grid-black-002 dark:bg-grid-white/[0.02]" />
      
      <div className="container mx-auto px-4 py-20">
        <div className="grid lg:grid-cols-2 gap-12 items-center">
          {/* Content */}
          <div className="space-y-8">
            <div className="space-y-4">
              <Badge variant="secondary" className="w-fit">
                🇮🇩 Melayani Rakyat Indonesia
              </Badge>
              
              <h1 className="text-4xl md:text-6xl font-bold tracking-tight">
                Bersama Membangun
                <span className="text-primary"> Indonesia Maju</span>
              </h1>
              
              <p className="text-lg text-muted-foreground max-w-2xl">
                Berkomitmen untuk memberikan pelayanan terbaik, memperjuangkan keadilan sosial, 
                dan menciptakan kemakmuran bersama bagi seluruh rakyat Indonesia.
              </p>
            </div>

            {/* CTA Buttons */}
            <div className="flex flex-col sm:flex-row gap-4">
              <Button size="lg" className="group">
                Dukung Kami
                <ArrowRight className="ml-2 h-4 w-4 transition-transform group-hover:translate-x-1" />
              </Button>
              
              <Button size="lg" variant="outline" className="group">
                <Play className="mr-2 h-4 w-4" />
                Tonton Profil
              </Button>
            </div>

            {/* Stats */}
            <div className="grid grid-cols-3 gap-6 pt-8">
              {stats.map((stat, index) => (
                <div key={index} className="text-center">
                  <div className="flex justify-center mb-2">
                    <div className="p-2 rounded-full bg-primary/10">
                      <stat.icon className="h-5 w-5 text-primary" />
                    </div>
                  </div>
                  <div className="text-2xl font-bold">{stat.value}</div>
                  <div className="text-sm text-muted-foreground">{stat.label}</div>
                </div>
              ))}
            </div>
          </div>

          {/* Image/Video */}
          <div className="relative">
            <div className="relative aspect-square rounded-2xl overflow-hidden shadow-2xl">
              <div className="w-full h-full bg-gradient-to-br from-primary/20 to-secondary/20 flex items-center justify-center">
                <div className="text-center space-y-4">
                  <div className="w-32 h-32 mx-auto rounded-full bg-primary/10 flex items-center justify-center">
                    <Users className="h-16 w-16 text-primary" />
                  </div>
                  <h3 className="text-2xl font-bold">Bersama Rakyat</h3>
                  <p className="text-muted-foreground">Melayani dengan hati</p>
                </div>
              </div>
              
              {/* Play Button Overlay */}
              <button
                onClick={() => setIsPlaying(true)}
                className="absolute inset-0 flex items-center justify-center bg-black/20 hover:bg-black/30 transition-colors group"
              >
                <div className="w-16 h-16 rounded-full bg-white/90 flex items-center justify-center group-hover:scale-110 transition-transform">
                  <Play className="h-6 w-6 text-primary ml-1" />
                </div>
              </button>
            </div>

            {/* Floating Cards */}
            <div className="absolute -top-4 -right-4 bg-white dark:bg-gray-800 rounded-lg shadow-lg p-4 hidden lg:block">
              <div className="flex items-center space-x-3">
                <div className="w-3 h-3 rounded-full bg-green-500 animate-pulse" />
                <div>
                  <p className="text-sm font-medium">Live Now</p>
                  <p className="text-xs text-muted-foreground">Sedang Online</p>
                </div>
              </div>
            </div>

            <div className="absolute -bottom-4 -left-4 bg-white dark:bg-gray-800 rounded-lg shadow-lg p-4 hidden lg:block">
              <div className="flex items-center space-x-3">
                <div className="text-2xl">📞</div>
                <div>
                  <p className="text-sm font-medium">Call Center</p>
                  <p className="text-xs text-muted-foreground">24/7 Siap Melayani</p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}