import { Card, CardContent } from '@/components/ui/card'
import { Target, Eye, Heart, Lightbulb } from 'lucide-react'

export default function VisiMisi() {
  const visi = {
    icon: Eye,
    title: "Visi",
    description: "Terwujudnya Indonesia yang berdaulat, mandiri, dan berkepribadian berlandaskan gotong royong.",
    color: "text-blue-600"
  }

  const misi = [
    {
      icon: Target,
      title: "Kesejahteraan Sosial",
      description: "Meningkatkan kualitas hidup masyarakat melalui program kesejahteraan sosial yang merata.",
      color: "text-green-600"
    },
    {
      icon: Heart,
      title: "Pendidikan Berkualitas",
      description: "Memajukan pendidikan yang berkualitas dan terjangkau untuk seluruh anak bangsa.",
      color: "text-purple-600"
    },
    {
      icon: Lightbulb,
      title: "Inovasi & Teknologi",
      description: "Mendorong inovasi dan pemanfaatan teknologi untuk kemajuan bangsa.",
      color: "text-orange-600"
    }
  ]

  return (
    <section className="py-20 bg-muted/30">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="text-3xl md:text-4xl font-bold mb-4">
            Visi & Misi
          </h2>
          <p className="text-lg text-muted-foreground max-w-2xl mx-auto">
            Komitmen kami untuk membangun Indonesia yang lebih baik
          </p>
        </div>

        <div className="grid lg:grid-cols-2 gap-8 mb-12">
          {/* Visi */}
          <Card className="border-2 border-primary/20 hover:shadow-lg transition-shadow">
            <CardContent className="p-8">
              <div className="flex items-start space-x-4">
                <div className={`p-3 rounded-full bg-primary/10 ${visi.color}`}>
                  <visi.icon className="h-8 w-8" />
                </div>
                <div className="flex-1">
                  <h3 className="text-2xl font-bold mb-3">{visi.title}</h3>
                  <p className="text-muted-foreground leading-relaxed">
                    {visi.description}
                  </p>
                </div>
              </div>
            </CardContent>
          </Card>

          {/* Misi Preview */}
          <div className="space-y-4">
            <h3 className="text-2xl font-bold mb-6">Misi</h3>
            {misi.map((item, index) => (
              <Card key={index} className="hover:shadow-md transition-shadow">
                <CardContent className="p-6">
                  <div className="flex items-start space-x-3">
                    <div className={`p-2 rounded-full bg-muted ${item.color}`}>
                      <item.icon className="h-5 w-5" />
                    </div>
                    <div>
                      <h4 className="font-semibold mb-1">{item.title}</h4>
                      <p className="text-sm text-muted-foreground">
                        {item.description}
                      </p>
                    </div>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>

        {/* Call to Action */}
        <div className="text-center">
          <p className="text-muted-foreground mb-4">
            Bergabunglah bersama kami dalam mewujudkan visi ini
          </p>
          <div className="flex flex-col sm:flex-row gap-4 justify-center">
            <button className="px-6 py-3 bg-primary text-primary-foreground rounded-lg hover:bg-primary/90 transition-colors">
              Pelajari Lebih Lanjut
            </button>
            <button className="px-6 py-3 border border-border rounded-lg hover:bg-muted transition-colors">
              Download Program Kerja
            </button>
          </div>
        </div>
      </div>
    </section>
  )
}