'use client'

import { useState } from 'react'
import { Button } from '@/components/ui/button'
import { 
  Share2, 
  Facebook, 
  Twitter, 
  MessageCircle, 
  Link2,
  Check
} from 'lucide-react'

interface ShareButtonsProps {
  url?: string
  title?: string
  description?: string
  className?: string
}

export default function ShareButtons({ 
  url = typeof window !== 'undefined' ? window.location.href : '',
  title = 'Politisi Indonesia - Melayani Rakyat',
  description = 'Website resmi politisi Indonesia. Berjuang untuk kemakmuran dan keadilan sosial.',
  className = ''
}: ShareButtonsProps) {
  const [copied, setCopied] = useState(false)

  const shareLinks = [
    {
      name: 'Facebook',
      icon: Facebook,
      url: `https://www.facebook.com/sharer/sharer.php?u=${encodeURIComponent(url)}`,
      color: 'bg-blue-600 hover:bg-blue-700'
    },
    {
      name: 'Twitter',
      icon: Twitter,
      url: `https://twitter.com/intent/tweet?url=${encodeURIComponent(url)}&text=${encodeURIComponent(title)}`,
      color: 'bg-sky-500 hover:bg-sky-600'
    },
    {
      name: 'WhatsApp',
      icon: MessageCircle,
      url: `https://wa.me/?text=${encodeURIComponent(`${title} ${url}`)}`,
      color: 'bg-green-600 hover:bg-green-700'
    },
    {
      name: 'LinkedIn',
      icon: Link2,
      url: `https://www.linkedin.com/sharing/share-offsite/?url=${encodeURIComponent(url)}`,
      color: 'bg-blue-700 hover:bg-blue-800'
    }
  ]

  const handleCopyLink = async () => {
    try {
      await navigator.clipboard.writeText(url)
      setCopied(true)
      setTimeout(() => setCopied(false), 2000)
    } catch (err) {
      console.error('Failed to copy link:', err)
    }
  }

  const handleShare = (shareUrl: string) => {
    window.open(shareUrl, '_blank', 'width=600,height=400')
  }

  return (
    <div className={`flex items-center space-x-2 ${className}`}>
      <span className="text-sm font-medium text-muted-foreground mr-2">Bagikan:</span>
      
      {shareLinks.map((link) => (
        <Button
          key={link.name}
          variant="outline"
          size="sm"
          onClick={() => handleShare(link.url)}
          className={`${link.color} text-white border-none hover:opacity-90 transition-opacity`}
          title={`Bagikan ke ${link.name}`}
        >
          <link.icon className="h-4 w-4" />
        </Button>
      ))}
      
      <Button
        variant="outline"
        size="sm"
        onClick={handleCopyLink}
        className="relative"
        title="Salin Link"
      >
        {copied ? (
          <Check className="h-4 w-4 text-green-600" />
        ) : (
          <Link2 className="h-4 w-4" />
        )}
      </Button>
    </div>
  )
}