'use client'

// Fixed TikTok import issue
import { Facebook, Instagram, Twitter, Youtube, Linkedin, Music } from 'lucide-react'

interface SocialLink {
  name: string
  url: string
  icon: any
  color: string
}

interface SocialLinksProps {
  className?: string
  variant?: 'default' | 'header' | 'footer'
  size?: 'sm' | 'md' | 'lg'
}

export default function SocialLinks({ 
  className = '', 
  variant = 'default',
  size = 'md'
}: SocialLinksProps) {
  // Default social links - bisa diupdate dari database
  const socialLinks: SocialLink[] = [
    {
      name: 'Facebook',
      url: 'https://facebook.com/politisiindonesia',
      icon: Facebook,
      color: 'hover:text-blue-600'
    },
    {
      name: 'Instagram',
      url: 'https://instagram.com/politisiindonesia',
      icon: Instagram,
      color: 'hover:text-pink-600'
    },
    {
      name: 'Twitter',
      url: 'https://twitter.com/politisiid',
      icon: Twitter,
      color: 'hover:text-sky-600'
    },
    {
      name: 'YouTube',
      url: 'https://youtube.com/c/politisiindonesia',
      icon: Youtube,
      color: 'hover:text-red-600'
    },
    {
      name: 'LinkedIn',
      url: 'https://linkedin.com/in/politisiindonesia',
      icon: Linkedin,
      color: 'hover:text-blue-700'
    },
    {
      name: 'TikTok',
      url: 'https://tiktok.com/@politisiindonesia',
      icon: Music,
      color: 'hover:text-gray-800'
    }
  ]

  const sizeClasses = {
    sm: 'h-4 w-4',
    md: 'h-5 w-5',
    lg: 'h-6 w-6'
  }

  const variantClasses = {
    default: 'flex space-x-4',
    header: 'hidden lg:flex items-center space-x-2',
    footer: 'flex space-x-4'
  }

  const linkClasses = {
    default: 'text-muted-foreground transition-colors',
    header: 'p-2 rounded-full hover:bg-muted transition-colors',
    footer: 'p-2 rounded-full bg-background hover:bg-muted transition-colors'
  }

  return (
    <div className={`${variantClasses[variant]} ${className}`}>
      {socialLinks.map((social) => {
        const Icon = social.icon
        return (
          <a
            key={social.name}
            href={social.url}
            target="_blank"
            rel="noopener noreferrer"
            className={`${linkClasses[variant]} ${social.color}`}
            aria-label={social.name}
          >
            <Icon className={sizeClasses[size]} />
          </a>
        )
      })}
    </div>
  )
}